<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name');

    public function stores()
    {
        return $this->hasMany('Store');
    }

    public function families()
    {
        return $this->hasMany('Family');
    }

    public function companies()
    {
        return $this->hasMany('Company');
    }

    public function followers()
    {
        return $this->belongsToMany('Client');
    }

}